<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @package Elite_Northeast_Realty
 */

get_header();
?>

<main id="primary" class="site-main">
    <section class="py-24 bg-gray-50">
        <div class="container mx-auto px-4">
            <div class="max-w-2xl mx-auto text-center">
                <!-- 404 Icon -->
                <div class="mb-8">
                    <svg class="w-32 h-32 text-gray-400 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                    </svg>
                </div>
                
                <!-- Error Message -->
                <h1 class="text-6xl font-bold text-gray-900 mb-4">404</h1>
                <h2 class="text-3xl font-semibold text-gray-800 mb-4">Oops! Page Not Found</h2>
                <p class="text-xl text-gray-600 mb-8">
                    The page you're looking for doesn't exist. It might have been moved or deleted.
                </p>
                
                <!-- Search Form -->
                <div class="bg-white rounded-lg shadow-md p-8 mb-8">
                    <h3 class="text-xl font-semibold text-gray-900 mb-4">Try searching for what you need:</h3>
                    <form role="search" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>" class="flex gap-2 max-w-md mx-auto">
                        <input type="search" 
                               class="flex-1 px-4 py-3 border border-gray-300 rounded-md focus:ring-2 focus:ring-gold-500 focus:border-gold-500" 
                               placeholder="Search properties, agents, or articles..." 
                               name="s" />
                        <button type="submit" class="bg-gold-600 text-white px-6 py-3 rounded-md hover:bg-gold-700 transition duration-300">
                            Search
                        </button>
                    </form>
                </div>
                
                <!-- Helpful Links -->
                <div class="bg-white rounded-lg shadow-md p-8">
                    <h3 class="text-xl font-semibold text-gray-900 mb-6">Here are some helpful links:</h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="group">
                            <div class="bg-gray-50 rounded-lg p-6 hover:bg-gold-50 transition duration-300">
                                <svg class="w-12 h-12 text-gold-600 mb-3 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                                </svg>
                                <h4 class="font-semibold text-gray-900 group-hover:text-gold-600 transition duration-300">Homepage</h4>
                                <p class="text-sm text-gray-600 mt-1">Return to our main page</p>
                            </div>
                        </a>
                        
                        <a href="<?php echo esc_url( home_url( '/properties' ) ); ?>" class="group">
                            <div class="bg-gray-50 rounded-lg p-6 hover:bg-gold-50 transition duration-300">
                                <svg class="w-12 h-12 text-gold-600 mb-3 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                                </svg>
                                <h4 class="font-semibold text-gray-900 group-hover:text-gold-600 transition duration-300">Browse Properties</h4>
                                <p class="text-sm text-gray-600 mt-1">View all available listings</p>
                            </div>
                        </a>
                        
                        <a href="<?php echo esc_url( home_url( '/agents' ) ); ?>" class="group">
                            <div class="bg-gray-50 rounded-lg p-6 hover:bg-gold-50 transition duration-300">
                                <svg class="w-12 h-12 text-gold-600 mb-3 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                </svg>
                                <h4 class="font-semibold text-gray-900 group-hover:text-gold-600 transition duration-300">Our Agents</h4>
                                <p class="text-sm text-gray-600 mt-1">Meet our professional team</p>
                            </div>
                        </a>
                        
                        <a href="<?php echo esc_url( home_url( '/contact' ) ); ?>" class="group">
                            <div class="bg-gray-50 rounded-lg p-6 hover:bg-gold-50 transition duration-300">
                                <svg class="w-12 h-12 text-gold-600 mb-3 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                                </svg>
                                <h4 class="font-semibold text-gray-900 group-hover:text-gold-600 transition duration-300">Contact Us</h4>
                                <p class="text-sm text-gray-600 mt-1">Get in touch with our team</p>
                            </div>
                        </a>
                    </div>
                    
                    <!-- Recent Properties -->
                    <?php
                    $recent_properties = new WP_Query( array(
                        'post_type' => 'property',
                        'posts_per_page' => 3,
                        'post_status' => 'publish',
                    ) );
                    
                    if ( $recent_properties->have_posts() ) : ?>
                        <div class="border-t pt-8">
                            <h3 class="text-xl font-semibold text-gray-900 mb-6">Recent Property Listings</h3>
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                                <?php while ( $recent_properties->have_posts() ) : $recent_properties->the_post(); ?>
                                    <article class="text-left">
                                        <a href="<?php the_permalink(); ?>" class="block group">
                                            <?php if ( has_post_thumbnail() ) : ?>
                                                <div class="aspect-w-16 aspect-h-12 mb-3 overflow-hidden rounded-lg">
                                                    <?php the_post_thumbnail( 'medium', array( 'class' => 'w-full h-full object-cover group-hover:scale-105 transition duration-300' ) ); ?>
                                                </div>
                                            <?php endif; ?>
                                            <h4 class="font-semibold text-gray-900 group-hover:text-gold-600 transition duration-300 mb-1">
                                                <?php the_title(); ?>
                                            </h4>
                                            <?php
                                            $price = get_post_meta( get_the_ID(), '_property_price', true );
                                            if ( $price ) : ?>
                                                <p class="text-gold-600 font-semibold"><?php echo esc_html( elite_format_price( $price ) ); ?></p>
                                            <?php endif; ?>
                                        </a>
                                    </article>
                                <?php endwhile; ?>
                            </div>
                        </div>
                    <?php endif;
                    wp_reset_postdata();
                    ?>
                </div>
                
                <!-- Contact Support -->
                <div class="mt-8 text-gray-600">
                    <p class="mb-2">Still need help?</p>
                    <p>
                        <a href="tel:+1234567890" class="text-gold-600 hover:text-gold-700 font-semibold">Call us at (123) 456-7890</a>
                        <span class="mx-2">or</span>
                        <a href="mailto:info@elitenortheastrealty.com" class="text-gold-600 hover:text-gold-700 font-semibold">email us</a>
                    </p>
                </div>
            </div>
        </div>
    </section>
</main><!-- #main -->

<?php
get_footer();